<?php

error_reporting(0);

include ("includes/header.php");

//Check admin privileges
if ($_SESSION["isSuperAdmin"] == 0 && $_SESSION["isAnalyticsAdmin"] == 0)
{
    header("Location: admin.php");
    exit();
}

//Apply search filters
if (isset($_POST['applyFilter']))
{
    $startDate = $_POST["startDate"];
    $endDate = $_POST["endDate"];

    if (!empty($startDate) && !empty($endDate))
    {
        echo $startDate;
    }
}

function getAnalytics($platform, $startDate, $endDate)
{

    global $connect;

    //Set default values
    $data = array(
        "totCount" => 0,
        "totActiveCount" => 0,
        "totTodayCount" => 0,
        "totChargedCount" => 0,
        "totTodayUnCount" => 0
    );

    //Total users count
    if (!empty($startDate) && !empty($endDate))
    {
        $totQuery = mysqli_query($connect, "SELECT count(*) AS totalRegistered FROM users WHERE platform='$platform' AND signupDate BETWEEN '$startDate' AND '$endDate';");
    }
    else
    {
        $totQuery = mysqli_query($connect, "SELECT count(*) AS totalRegistered FROM users WHERE platform='$platform'");
    }
    $totRow = mysqli_fetch_assoc($totQuery);
    $data["totCount"] = $totRow["totalRegistered"];

    //Total active users
    if (!empty($startDate) && !empty($endDate))
    {
        $totActiveQuery = mysqli_query($connect, "SELECT count(*) AS totalActive FROM users WHERE subscriberState!='pending' AND platform='$platform' AND chargedDate BETWEEN '$startDate' AND '$endDate';");
    }
    else
    {
        $totActiveQuery = mysqli_query($connect, "SELECT count(*) AS totalActive FROM users WHERE subscriberState!='pending' AND platform='$platform';");
    }
    $totActiveRow = mysqli_fetch_assoc($totActiveQuery);
    $data["totActiveCount"] = $totActiveRow["totalActive"];

    //Today registered
    $totTodayQuery = mysqli_query($connect, "SELECT count(*) AS totalToday FROM users WHERE signupDate=CAST(NOW() AS DATE) AND platform='$platform' AND subscriberState='subscribed';");
    $totTodayRow = mysqli_fetch_assoc($totTodayQuery);
    $data["totTodayCount"] = $totTodayRow["totalToday"];

    //Today charged
    $totChargedQuery = mysqli_query($connect, "SELECT count(*) AS totalToday FROM users WHERE chargedDate=CAST(NOW() AS DATE) AND platform='$platform' AND subscriberState='subscribed';");
    $totChargedRow = mysqli_fetch_assoc($totChargedQuery);
    $data["totChargedCount"] = $totChargedRow["totalToday"];

    //Today unregistered
    $totTodayUnQuery = mysqli_query($connect, "SELECT count(*) AS totalUnToday FROM users WHERE unsubscribeDate=CAST(NOW() AS DATE) AND subscriberState='unsubscribed' AND platform='$platform';");
    $totTodayUnRow = mysqli_fetch_assoc($totTodayUnQuery);
    $data["totTodayUnCount"] = $totTodayUnRow["totalUnToday"];

    return $data;
}

//Load Ideabiz analytics
if($ENABLED_SERVICES["IDEABIZ"]){
    //Ideabiz Analytics
    $ideabizAnalytics = getAnalytics('ideabiz', $startDate, $endDate);
    $totCount_ideabiz = $ideabizAnalytics["totCount"];
    $totActiveCount_ideabiz = $ideabizAnalytics["totActiveCount"];
    $totTodayCount_ideabiz = $ideabizAnalytics["totTodayCount"];
    $totChargedCount_ideabiz = $ideabizAnalytics["totChargedCount"];
    $totTodayUnCount_ideabiz = $ideabizAnalytics["totTodayUnCount"];
}

//Load Ideamart analytics
$ideamartBase = 0;
if($ENABLED_SERVICES["IDEAMART"]){
    //Ideamart Analytics
    $ideamartAnalytics = getAnalytics('ideamart', $startDate, $endDate);
    $totCount = $ideamartAnalytics["totCount"];
    $totActiveCount = $ideamartAnalytics["totActiveCount"];
    $totTodayCount = $ideamartAnalytics["totTodayCount"];
    $totChargedCount = $ideamartAnalytics["totChargedCount"];
    $totTodayUnCount = $ideamartAnalytics["totTodayUnCount"];
    $ideamartBase = sendRequest("https://api.ideamart.io/subscription/query-base", array(
        "applicationId" => $IDEAMART_APP_ID,
        "password" => $IDEAMART_APP_PASSWORD
    )) ["baseSize"];
}

//Load mSpace analytics
$mspaceBase = 0;
if($ENABLED_SERVICES["MSPACE"]){
    //mSpace Analytics
    $mspaceAnalytics = getAnalytics('mspace', $startDate, $endDate);
    $totCount_mspace = $mspaceAnalytics["totCount"];
    $totActiveCount_mspace = $mspaceAnalytics["totActiveCount"];
    $totTodayCount_mspace = $mspaceAnalytics["totTodayCount"];
    $totChargedCount_mspace = $mspaceAnalytics["totChargedCount"];
    $totTodayUnCount_mspace = $mspaceAnalytics["totTodayUnCount"];
    $mspaceBase = sendRequest("https://api.mspace.lk/subscription/query-base", array(
        "applicationId" => $MSPACE_APP_ID,
        "password" => $MSPACE_APP_PASSWORD
    )) ["baseSize"];
}

function sendRequest($endPoint, $data)
{
    $payload = json_encode($data);
    $ch = curl_init($endPoint);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type:application/json'
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    error_log($result);
    return json_decode($result, true);
}
?>

    <h3>Filter by date</h3>

    <div class="row">
        <div class="col-md-12">
            <form action="#" method="post">
                Start date:
                <input type="date" name="startDate" />

                End date:
                <input type="date" name="endDate" />

                <input type="submit" class="btn btn-primary" value="Filter" name="applyFilter"/>
            </form>
        </div>
    </div>

    <?php if($ENABLED_SERVICES["IDEABIZ"]){ ?>

    <h3>IdeaBiz base</h3>

    <div class="row">
        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Total base size</p>
                    <h3 class="card-title"><?php echo $totCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total base
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Registered base size</p>
                    <h3 class="card-title"><?php echo $totActiveCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Pending charges</p>
                    <h3 class="card-title"><?php echo $totCount_ideabiz - $totActiveCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Registered today</p>
                    <h3 class="card-title"><?php echo $totTodayCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Registered today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Charged today</p>
                    <h3 class="card-title"><?php echo $totChargedCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Charged today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Unsubscribed today</p>
                    <h3 class="card-title"><?php echo $totTodayUnCount_ideabiz; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Total unregistered today
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php } ?>

    <?php if($ENABLED_SERVICES["IDEAMART"]){ ?>

    <h3>Ideamart base</h3>

    <div class="row">
        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Total base size</p>
                    <h3 class="card-title"><?php echo $totCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total base
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Registered base size</p>
                    <h3 class="card-title"><?php echo $totActiveCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Pending charges</p>
                    <h3 class="card-title"><?php echo $totCount - $totActiveCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">done_outline</i>
                    </div>
                    <p class="card-category">Total active users</p>
                    <h3 class="card-title"><?php echo $ideamartBase ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">done_outline</i> Total active
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Registered today</p>
                    <h3 class="card-title"><?php echo $totTodayCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Registered today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Charged today</p>
                    <h3 class="card-title"><?php echo $totChargedCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Charged today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Unsubscribed today</p>
                    <h3 class="card-title"><?php echo $totTodayUnCount; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Total unregistered today
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php } ?>

    <?php if($ENABLED_SERVICES["MSPACE"]){ ?>

    <h3>mSpace base</h3>

    <div class="row">
        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Total base size</p>
                    <h3 class="card-title"><?php echo $totCount_mspace; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total base
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Registered base size</p>
                    <h3 class="card-title"><?php echo $totActiveCount_mspace; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">group</i>
                    </div>
                    <p class="card-category">Pending charges</p>
                    <h3 class="card-title"><?php echo $totCount_mspace - $totActiveCount_mspace; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">group</i> Total registered
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">done_outline</i>
                    </div>
                    <p class="card-category">Total active users</p>
                    <h3 class="card-title"><?php echo $mspaceBase; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">done_outline</i> Total active
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Registered today</p>
                    <h3 class="card-title"><?php echo $totTodayCount_mspace; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Registered today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Charged today</p>
                    <h3 class="card-title"><?php echo $totChargedCount_mspace; ?>
                    <small>Users</small>
                  </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Successfully Charged today
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 col-sm-6">
            <div class="card card-stats">
                <div class="card-header card-header-warning card-header-icon">
                    <div class="card-icon">
                        <i class="material-icons">date_range</i>
                    </div>
                    <p class="card-category">Unsubscribed today</p>
                    <h3 class="card-title"><?php echo $totTodayUnCount_mspace; ?>
                    <small>Users</small>
                </h3>
                </div>
                <div class="card-footer">
                    <div class="stats">
                        <i class="material-icons">date_range</i> Total unregistered today
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php } ?>

    <?php include ("includes/footer.php"); ?>
