<?php
include("includes/header.php");

if($_SESSION["isAnalyticsAdmin"] == 1){
    header("Location: analytics.php");
    exit();
 }

$id = (int)$_GET["id"];

$message = "";
$category = "";

if(isset($id)){
    $query = mysqli_query($connect, "SELECT `message`, `category` FROM messages WHERE id='$id'");
    $data = mysqli_fetch_array($query);
    $rows = mysqli_num_rows($query);
    if($rows == 0){
        header("Location: admin.php");
        exit();
    }
    $message = $data["message"];
    $category = $data["category"];
} else {
    header("Location: admin.php");
    exit();
}

$errors = array();

if(isset($_POST["postMsg"])){
    $category = $_POST["category"];
    $message = $_POST["message"];
    $author = $_SESSION["user"];

    if(empty($category)){
        array_push($errors, "Category name is required");
    }
    
    if(empty($message)){
        array_push($errors, "Message is required");
    }

    if(empty($author)){
        array_push($errors, "An error has occured");
    }

    if(empty($errors)){
        $category = mysqli_real_escape_string($connect, $category);
        $message = mysqli_real_escape_string($connect, $message);
        $author = mysqli_real_escape_string($connect, $author);
        $query = mysqli_query($connect, "UPDATE messages SET `message`='$message', `category`='$category' WHERE `id`='$id';");
        if($query){
            array_push($errors, "Successfully updated message");
        } else {
            array_push($errors, "An error has occured");
        }
    }
}
?>

<div class="row">
   <div class="col-md-8">
      <div class="card">
         <div class="card-header card-header-primary">
            <h4 class="card-title">Edit message</h4>
            <p class="card-category">Edit message in database</p>
         </div>
         <div class="card-body">
            <form method="post" action="#">
               <div class="row">
                  <div class="col-md-12">
                     <div class="form-group">
                        <label class="bmd-label-floating">Category</label>
                        <select class="form-control" name="category">
                        <?php
                        $catQ = mysqli_query($connect, "SELECT * FROM categories ORDER BY id ASC");
                        while($data = mysqli_fetch_array($catQ)){
                            echo '<option value="'.$data['id'].'">'.$data['category'].'</option>';
                        }
                        ?>
                        </select>
                     </div>
                  </div>
               </div>
               <div class="row">
                  <div class="col-md-12">
                     <div class="form-group">
                        <label>Message</label>
                        <div class="form-group">
                           <textarea class="form-control" rows="5" placeholder="Enter your message here" name="message"><?php echo $message ?></textarea>
                        </div>
                     </div>
                  </div>
               </div>
               <input type="submit" class="btn btn-primary pull-right" value="Save Message" name="postMsg"/>
               <div class="clearfix"></div>
            </form>
         </div>
      </div>
      <?php
        if(!empty($errors)) {
            echo '<div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <i class="material-icons">close</i>
            </button>';
            foreach($errors as $error){
                echo '<span><b>'.$error.'</b></span>';
            }
            echo'</div>';
        }
        ?>
   </div>
</div>

<?php
include("includes/footer.php");
?>