<?php
include("../connection.php");
include("../functions.php");
include("../ideabizFunctions.php");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title><?php echo $APP_DESC; ?></title>
    <!-- MDB icon -->
    <!-- <link rel="icon" href="img/mdb-favicon.ico" type="image/x-icon" /> -->
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <!-- Google Fonts Roboto -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" />
    <!-- MDB -->
    <link rel="stylesheet" href="css/mdb.min.css" />

    <link rel="stylesheet" href="css/custom.css" />

</head>

<?php
$errors = array();

//Check required params
if (empty($_GET['appRef']) || empty($_GET['otpref']) || empty($_GET['name']) || empty($_GET['platform']) || empty($_GET['mobile']) || empty($_GET['category'])) {
    header("Location: index.php");
    exit();
}

//Set app reference
$appRef = mysqli_real_escape_string($connect, $_GET['appRef']);
$name = mysqli_real_escape_string($connect, $_GET['name']);
$mobile = mysqli_real_escape_string($connect, $_GET['mobile']);
$device = mysqli_real_escape_string($connect, $_SERVER['HTTP_USER_AGENT']);
$category = mysqli_real_escape_string($connect, $_GET['category']);

$otpref = $_GET['otpref'];
$platform = $_GET['platform'];

if (isset($_POST["verifyOtp"])) {
    $otpInput = $_POST["otpInput"];

    if (!empty($otpInput)) {
        if ($platform == "ideamart") {
            $telco = new TelcoOperations($IDEAMART_ENDPOINT, $IDEAMART_APP_ID, $IDEAMART_APP_PASSWORD, $connect, "ideamart");
        } else if ($platform == "ideabiz") {
            $telco = new IdeabizOperations($connect, $IDEABIZ_USERNAME, $IDEABIZ_PASSWORD, $IDEABIZ_CONSUMER_KEY, $IDEABIZ_CONSUMER_SECRET);
        } else {
            $telco = new TelcoOperations($MSPACE_ENDPOINT, $MSPACE_APP_ID, $MSPACE_APP_PASSWORD, $connect, "mspace");
        }
        //Verify OTP Code
        $otpResp = $telco->verifyOtpCode($otpref, $otpInput);
 
        if (isset($otpResp["statusCode"]) && ($otpResp["statusCode"] == "S1000" || $otpResp["statusCode"] == "SUCCESS")) {

            $subId = ($platform == "ideabiz") ? $otpResp["data"]["msisdn"] : $otpResp["subscriberId"];

            //Insert user to DB
            $telco->completeOtpSubscription($subId, $category, $name, $appRef, $mobile, $device);

            //Redirect user to success page
            header("Location: success.php");
            exit();
        } else if (isset($otpResp["statusDetail"])) {
            array_push($errors, $otpResp["statusDetail"]);
        } else if (isset($otpResp["message"])) {
            array_push($errors, $otpResp["message"]);
        } else {
            array_push($errors, "An error has occured while verifying OTP code! Please try again later.");
        }
    } else {
        array_push($errors, "OTP code is required!");
    }
}

?>

<body>
    <div class="container">
        <div class="d-flex justify-content-center align-items-center" style="height: 100vh">
            <div class="text-center">
                <div class="card">
                    <div class="row">
                        <div class="col-md">
                            <?php include("slider.php"); ?>
                        </div>
                        <div class="col-md maincontent" style="display: table;">
                            <div class="card-body" style="display: table-cell;vertical-align: middle;">
                                <img src="img/custom/logo.png" width="100" style="margin-bottom: 31px;" />
                                <h5 class="card-title display-8">AppWin Astro - පලාපල සේවාව</h5>
                                <h5 class="card-title display-6">OTP කේතය තහවුරු කරන්න</h5>
                                <form method="post" action="#">

                                    <div class="form-outline mb-4">
                                        <input type="text" id="otpInput" name="otpInput" class="form-control" />
                                        <label class="form-label" for="otpInput">OTP Code</label>
                                    </div>

                                    <!-- Submit button -->
                                    <button type="submit" class="button-class btn btn-primary btn-block mb-4" name="verifyOtp" >Verify Number</button>
                                </form>
                                <p class="card-text" style="font-size: 12px;color:#003366;max-width: 300px;margin: auto;">ලියාපදිංචිය සාර්ථක කිරීමට කරුණාකර ඔබට SMS හරහා ලැබුණු කේතය ඇතුළත් කරන්න</p>
                                <?php
                                if (!empty($errors)) {
                                    foreach ($errors as $error) {
                                        echo '<p class="note note-danger"><strong>Error:</strong> ' . $error . '</p>';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End your project here-->

    <!-- MDB -->
    <script type="text/javascript" src="js/mdb.min.js"></script>
    <!-- Custom scripts -->
    <script type="text/javascript"></script>
</body>

</html>