<?php
class TelcoOperations
{
    public $ENDPOINT;
    public $APP_ID;
    public $APP_PASSWORD;
    public $CONNECT;
    public $PLATFORM;

    function __construct($ENDPOINT, $APP_ID, $APP_PASSWORD, $CONNECT, $PLATFORM)
    {
        $this->ENDPOINT = $ENDPOINT;
        $this->APP_ID = $APP_ID;
        $this->APP_PASSWORD = $APP_PASSWORD;
        $this->CONNECT = $CONNECT;
        $this->PLATFORM = $PLATFORM;
    }

    function getEndpoint()
    {
        return $this->ENDPOINT;
    }

    function registerUser($address, $category)
    {
        if ($this->checkSubscription($address) === "UNREGISTERED") {
            if ($this->subscribeUser($address) != "UNREGISTERED") {
                return $this->completeSubscription($address, $category);
            } else {
                return ("Unable to subscribe user at this time.");
            }
        } else {
            return $this->completeSubscription($address, $category);
        }
    }

    function completeSubscription($address, $category)
    {
        $findQuery = mysqli_query($this->CONNECT, "SELECT id FROM users WHERE subNumber='$address';");
        if ($findQuery) {
            $userRows = mysqli_num_rows($findQuery);
            if ($userRows == 0) {
                $query = mysqli_query($this->CONNECT, "INSERT INTO `users` (`id`, `subNumber`, `fullName`, `category`, `platform`, `signupDate`) VALUES (NULL, '$address', 'User', '$category', '$this->PLATFORM', now());");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            } else {
                $query = mysqli_query($this->CONNECT, "UPDATE `users` SET subscriberState='pending', category='$category' WHERE subNumber='$address';");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            }
        } else {
            return ("An error has occured, please try again.");
        }
    }

    //Complete subscription with optional params
    function completeOtpSubscription($address, $category, $name, $appRef, $mobile, $device)
    {
        $findQuery = mysqli_query($this->CONNECT, "SELECT id FROM users WHERE subNumber='$address';");
        if ($findQuery) {
            $userRows = mysqli_num_rows($findQuery);
            if ($userRows == 0) {
                $query = mysqli_query($this->CONNECT, "INSERT INTO `users` (`id`, `subNumber`, `fullName`, `category`, `platform`, `signupDate`, `referal`, `mobile`, `device`) VALUES (NULL, '$address', '$name', '$category', '$this->PLATFORM', now(), '$appRef', '$mobile', '$device');");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            } else {
                $query = mysqli_query($this->CONNECT, "UPDATE `users` SET subscriberState='pending', category='$category', fullName='$name', device='$device' WHERE subNumber='$address';");
                if ($query) {
                    return ("You have been successfully registered. Await for SMS updates!");
                } else {
                    return ("An error has occured, please try registering later.");
                }
            }
        } else {
            return ("An error has occured, please try again.");
        }
    }

    function setCategory($address, $category)
    {
        $query = mysqli_query($this->CONNECT, "UPDATE `users` SET category='$category' WHERE subNumber='$address';");
        if ($query) {
            return ("Your language has been successfully updated.");
        } else {
            return ("Failed updating your language, please try again.");
        }
    }

    //Subscribe user: Ideamart, mSpace
    function subscribeUser($subNumber)
    {
        $data = array(
            'applicationId' => $this->APP_ID,
            'password' => $this->APP_PASSWORD,
            'subscriberId' => $subNumber,
            'action' => '1'
        );
        $res = $this->sendRequest($this->ENDPOINT . "/subscription/send", $data);
        return $res["subscriptionStatus"];
    }

    //Subscription check: Ideamart, mSpace
    function checkSubscription($subNumber)
    {
        $data = array(
            'applicationId' => $this->APP_ID,
            'password' => $this->APP_PASSWORD,
            'subscriberId' => $subNumber
        );
        $res = $this->sendRequest($this->ENDPOINT . "/subscription/getStatus", $data);
        return $res["subscriptionStatus"];
    }

    //Send SMS message: Ideamart, mSpace
    function sendMessage($subNumber, $message)
    {
        $data = array(
            'applicationId' => $this->APP_ID,
            'password' => $this->APP_PASSWORD,
            'destinationAddresses' => array(
                $subNumber
            ),
            'message' => $message
        );
        $res = $this->sendRequest($this->ENDPOINT . "/sms/send", $data);
        return $res["statusDetail"];
    }

    // Get OTP Code via SMS
    function getNormalOtp($mobileNumber, $hash, $device, $os, $appCode)
    {
        $data = array(
            'applicationId' => $this->APP_ID,
            'password' => $this->APP_PASSWORD,
            'subscriberId' => 'tel:94' . substr($mobileNumber, 1),
            'applicationHash' => $hash,
            'applicationMetaData'  => array(
                'client' => 'MOBILEAPP',
                'device' => $device,
                'os' => $os,
                'appCode' => $appCode
            )
        );
        if ($this->PLATFORM == "ideamart") {
            return $this->sendRequest($this->ENDPOINT . "/subscription/otp/request", $data);
        } else {
            return $this->sendRequest($this->ENDPOINT . "/otp/request", $data);
        }
    }

    // Verify OTP Code via SMS
    function verifyOtpCode($otpRef, $otpCode)
    {
        $data = array(
            'applicationId' => $this->APP_ID,
            'password' => $this->APP_PASSWORD,
            'referenceNo' => $otpRef,
            'otp' => $otpCode
        );
        if ($this->PLATFORM == "ideamart") {
            return $this->sendRequest($this->ENDPOINT . "/subscription/otp/verify", $data);
        } else {
            return $this->sendRequest($this->ENDPOINT . "/otp/verify", $data);
        }
    }

    function sendRequest($endPoint, $data)
    {
        $payload = json_encode($data);
        $ch = curl_init($endPoint);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type:application/json'
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        error_log($result);
        return json_decode($result, true);
    }

    function sendRequestAuth($endPoint, $data, $token)
    {
        $payload = json_encode($data);
        $ch = curl_init($endPoint);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type:application/json',
            'Authorization:Bearer ' . $token
        ));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        error_log($result);
        return json_decode($result, true);
    }
}
