<?php
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');
ini_set('display_errors', 1);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('error_log', 'subscription-error-log.log');

$platform = "ideabiz";
include("connection.php");
require("functions.php");

$telco = new TelcoOperations($ENDPOINT, $APP_ID, $APP_PASSWORD, $connect, $platform);

try {
    $array = json_decode(file_get_contents('php://input'), true);

    //Fetch data from ideabiz sub listener
    $action = $array['action'];
    $subscriberId = $array['msisdn'];
    $applicationId = $array['appID'];
    $status = $array['status'];
    $subscriberId = mysqli_real_escape_string($connect, $subscriberId);
    
    error_log($array['msisdn']. " ".$array['status']);

    if($applicationId == $APP_ID){
        if (strcmp($status, "SUBSCRIBED") == 0) {

            $telco->completeSubscription($subscriberId, "1");

            $query = mysqli_query($connect, "UPDATE `users` SET subscriberState='subscribed', chargedDate=NOW(), unsubscribeDate=NULL WHERE subNumber='$subscriberId';");
            
            if($query){
                sendResponse("Subscription Successful");
            } else {
                sendResponse("Subscription Unsuccessful");
            }

        } else if ($status == 'NOT_SUBSCRIBED') {

            $query = mysqli_query($connect, "UPDATE `users` SET subscriberState='unsubscribed', unsubscribeDate=NOW() WHERE subNumber='$subscriberId';");
            
            if($query){
                sendResponse("Unregistration Successful");
            } else {
                sendResponse("Failed unregistration");
            }

        } else {
            sendResponse("Failed un/registration");
        } 
    } else {
        sendResponse("APP ID mismatch");
    }

} catch (SMSServiceException $e) {
    error_log($e->getErrorMessage());
}

function sendResponse($message){
    error_log($message);
    echo json_encode(array(
        "MESSAGE" => $message
    ));
}
?>