<?php
header('Content-Type: application/json');
date_default_timezone_set('Asia/Colombo');
ini_set('display_errors', 1);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set('error_log', 'subscription-error-log.log');
$platform = $_GET["platform"];
include("connection.php");
require("functions.php");
$telco = new TelcoOperations($ENDPOINT, $APP_ID, $APP_PASSWORD, $connect, $platform);
try {
    $array = json_decode(file_get_contents('php://input'), true);
    $timeStamp = $array['timeStamp'];
    $subscriberId = $array['subscriberId'];
    if (strpos($subscriberId, 'tel:') !== true) {
        $subscriberId = "tel:" . $subscriberId;
    }
    $applicationId = $array['applicationId'];
    $version = $array['version'];
    $status = $array['status'];
    error_log($array['subscriberId'] . " " . $array['status']);
    $subscriberId = mysqli_real_escape_string($connect, $subscriberId);
    if ($applicationId == $APP_ID) {
        if (strcmp($status, "REGISTERED") == 0) {
            if ($platform == "mspace") {
                $response = $telco->registerUser($subscriberId, "1");
                sendResponse($response);
            }
            $query = mysqli_query($connect, "UPDATE `users` SET subscriberState='subscribed', chargedDate=NOW(), unsubscribeDate=NULL WHERE subNumber='$subscriberId';");
            if ($query) {
                $telco->sendMessage($subscriberId, $APP_WELCOME_MESSAGE);
            } else {
                $telco->sendMessage($subscriberId, "Unable to register. Please unsubscribe and subscribe later.");
            }
        } else if ($status == 'UNREGISTERED') {
            $query = mysqli_query($connect, "UPDATE `users` SET subscriberState='unsubscribed', unsubscribeDate=NOW() WHERE subNumber='$subscriberId';");
            if ($query) {
                sendResponse("Unregistration Successful");
            } else {
                sendResponse("Failed unregistration");
            }
        } else {
            sendResponse("Failed un/registration");
        }
    }
} catch (SMSServiceException $e) {
    error_log($e->getErrorMessage());
}

function sendResponse($message)
{
    error_log($message);
    echo json_encode(array(
        "MESSAGE" => $message
    ));
}
