<?php
ini_set('error_log', 'ussd-app-error.log');
require 'libs/MoUssdReceiver.php';
require 'libs/MtUssdSender.php';
$platform = $_GET["platform"];
include("connection.php");
require("functions.php");

$receiver = new UssdReceiver();
$sender = new UssdSender($ENDPOINT . '/ussd/send', $APP_ID, $APP_PASSWORD);
$telco = new TelcoOperations($ENDPOINT, $APP_ID, $APP_PASSWORD, $connect, $platform);

$receiverSessionId = $receiver->getSessionId();
$content = $receiver->getMessage(); // get the message content
$address = $receiver->getAddress(); // get the sender's address
$requestId = $receiver->getRequestID(); // get the request ID
$applicationId = $receiver->getApplicationId(); // get application ID
$encoding = $receiver->getEncoding(); // get the encoding value
$version = $receiver->getVersion(); // get the version
$sessionId = $receiver->getSessionId(); // get the session ID;
session_id($sessionId);
session_start();
$ussdOperation = $receiver->getUssdOperation(); // get the ussd operation

error_log($address . " " . $content);

$responseMsg = array(
    "main" =>
        $APP_DESC."
1. Yes
2. No
99. Exit"
);

if ($ussdOperation == "mo-init") {
    try {
        if ($telco->checkSubscription($address) === "UNREGISTERED") {
            $_SESSION["menu"] = "main";
            $sender->ussd($sessionId, $responseMsg["main"], $address);
        } else {
            $_SESSION["menu"] = "main_end";
            $sender->ussd($sessionId, 'You have already subscribed
99. Exit', $address);
        }
    } catch (Exception $e) {
        $sender->ussd($sessionId, 'Sorry error occured try again', $address);
    }
} else {

    $cuch_menu = $_SESSION["menu"];

    switch ($cuch_menu) {
        case "main":    // Following is the main menu
            switch ($receiver->getMessage()) {
                case "1":
                case "yes":
                case "Yes":
                case "Ok":
                case "ok":
                    $sender->ussd($sessionId, $telco->registerUser($address, "1"), $address);
                    $_SESSION["menu"] = "main_end";
                    break;

                default:
                    $_SESSION["menu"] = "main";
                    $sender->ussd($sessionId, $responseMsg["main"], $address);
                    break;
            }
            break;
        case "main_end":
            $_SESSION["menu"] = "main";
            $sender->ussd($sessionId, $responseMsg["main"], $address);
            break;
    }

}
?>