<?php
ini_set('error_log', 'ussd-app-error.log');
require 'libs/MoUssdReceiver.php';
require 'libs/MtUssdSender.php';
$platform = $_GET["platform"];
include("connection.php");
require("functions.php");

$receiver = new UssdReceiver();
$sender   = new UssdSender($ENDPOINT . '/ussd/send', $APP_ID, $APP_PASSWORD);
$telco    = new TelcoOperations($ENDPOINT, $APP_ID, $APP_PASSWORD, $connect, $platform);

$receiverSessionId = $receiver->getSessionId();
$content           = $receiver->getMessage(); // get the message content
$address           = $receiver->getAddress(); // get the sender's address
$requestId         = $receiver->getRequestID(); // get the request ID
$applicationId     = $receiver->getApplicationId(); // get application ID
$encoding          = $receiver->getEncoding(); // get the encoding value
$version           = $receiver->getVersion(); // get the version
$sessionId         = $receiver->getSessionId(); // get the session ID;
session_id($sessionId);
session_start();
$ussdOperation = $receiver->getUssdOperation(); // get the ussd operation

error_log($address . " " . $content);

/*
$telco->setWelcomeMessage("1-IT-Sware
2-IT-HWare
3-Restaurants/Food
4-Banking
5-Telecoms
6-Hospitality/Tourism
7-Security
8-Teaching
9-Eng-Mech
10-Clothing
11-Airline/Marine
12-Fashion/Beauty
13-Sales/Marketing
14-Admin
15-Finance
16-Logistics
Please send 'apply cat <code>' to 77100");
*/

$responseMsg = array(
    "main" => $APP_DESC."
Please choose your language
1. Sinhala
2. English
99. Exit",
    
    "sinhala_main" => "Obata awasya rakiyaa kaandaya thoranna
1. Continue
99. Back",
    
    "english_main" => "Please choose the job category you want
1. Continue
99. Back",
    
    "cat_1" => "1. IT-SW/QA/Web
2. IT-HW/Networks
3. Hotels/Restaurants/Food
4. Banking/Insurance
5. IT-Telecom
98. Next
99. Back",
    
    "cat_2" => "6. Hospitality/Tourism
7. Security
8. Teaching/Academic
9. Eng-Mech/Auto/Elec
10. Apparel/Clothing
98. Next
99. Back",
    
    "cat_3" => "11. Airline/Ticketing/Marine
12. Fashion/Beauty
13. Sales/Marketing
14. OfficeAdmin/Secretary/Receptionist
15. Finance
99. Back",
    
    "register_confirmation" => "Do you want to subscribe?
1. Yes
2. No"
);

if ($ussdOperation == "mo-init") {
    try {
        if ($telco->checkSubscription($address) === "UNREGISTERED") {
            $_SESSION["menu"] = "main";
            $sender->ussd($sessionId, $responseMsg["main"], $address);
        } else {
            $_SESSION["menu"] = "main_end";
            $sender->ussd($sessionId, 'You have already subscribed
99. Exit', $address);
        }
    }
    catch (Exception $e) {
        $sender->ussd($sessionId, 'Sorry error occured try again', $address);
    }
} else {
    
    $cuch_menu = $_SESSION["menu"];
    
    switch ($cuch_menu) {
        
        case "main":
            switch ($receiver->getMessage()) {
                case "1":
                    $_SESSION["menu"] = "sinhala_main";
                    $sender->ussd($sessionId, $responseMsg["sinhala_main"], $address);
                    break;
                
                case "2":
                    $_SESSION["menu"] = "english_main";
                    $sender->ussd($sessionId, $responseMsg["english_main"], $address);
                    break;
                
                default:
                    $_SESSION["menu"] = "main";
                    $sender->ussd($sessionId, $responseMsg["main"], $address);
                    break;
            }
            break;
        
        case "sinhala_main":
            switch ($receiver->getMessage()) {
                case "1":
                case "yes":
                case "Yes":
                case "Ok":
                case "ok":
                    $_SESSION["menu"] = "cat_1";
                    $sender->ussd($sessionId, $responseMsg["cat_1"], $address);
                    break;

                default:
                    $_SESSION["menu"] = "main";
                    $sender->ussd($sessionId, $responseMsg["main"], $address);
                    break;
            }
            break;
        
        case "english_main":
            switch ($receiver->getMessage()) {
                case "1":
                case "yes":
                case "Yes":
                case "Ok":
                case "ok":
                    $_SESSION["menu"] = "cat_1";
                    $sender->ussd($sessionId, $responseMsg["cat_1"], $address);
                    break;

                default:
                    $_SESSION["menu"] = "main";
                    $sender->ussd($sessionId, $responseMsg["main"], $address);
                    break;
            }
            break;
        
        case "cat_1":
            if ($receiver->getMessage() == "1" || $receiver->getMessage() == "2" || $receiver->getMessage() == "3" || $receiver->getMessage() == "4" || $receiver->getMessage() == "5") {
                $_SESSION["menu"]     = "register_confirmation";
                $_SESSION["category"] = $receiver->getMessage();
                $sender->ussd($sessionId, $responseMsg["register_confirmation"], $address);
            } else if ($receiver->getMessage() == "98") {
                $_SESSION["menu"] = "cat_2";
                $sender->ussd($sessionId, $responseMsg["cat_2"], $address);
            } else {
                $_SESSION["menu"] = "main";
                $sender->ussd($sessionId, $responseMsg["main"], $address);
            }
            break;
        
        case "cat_2":
            if ($receiver->getMessage() == "6" || $receiver->getMessage() == "7" || $receiver->getMessage() == "8" || $receiver->getMessage() == "9" || $receiver->getMessage() == "10") {
                $_SESSION["menu"]     = "register_confirmation";
                $_SESSION["category"] = $receiver->getMessage();
                $sender->ussd($sessionId, $responseMsg["register_confirmation"], $address);
            } else if ($receiver->getMessage() == "98") {
                $_SESSION["menu"] = "cat_3";
                $sender->ussd($sessionId, $responseMsg["cat_3"], $address);
            } else {
                $_SESSION["menu"] = "cat_1";
                $sender->ussd($sessionId, $responseMsg["cat_1"], $address);
            }
            break;
        
        case "cat_3":
            if ($receiver->getMessage() == "11" || $receiver->getMessage() == "12" || $receiver->getMessage() == "13" || $receiver->getMessage() == "14" || $receiver->getMessage() == "15" || $receiver->getMessage() == "16") {
                $_SESSION["menu"]     = "register_confirmation";
                $_SESSION["category"] = $receiver->getMessage();
                $sender->ussd($sessionId, $responseMsg["register_confirmation"], $address);
            } else {
                $_SESSION["menu"] = "cat_2";
                $sender->ussd($sessionId, $responseMsg["cat_2"], $address);
            }
            break;
        
        case "main_end":
            $_SESSION["menu"] = "main";
            $sender->ussd($sessionId, $responseMsg["main"], $address);
            break;
        
        case "register_confirmation":
            switch ($number = $receiver->getMessage()) {
                case "1":
                case "yes":
                case "Yes":
                case "Ok":
                case "ok":
                    $_SESSION["menu"] = "main_end";
                    $sender->ussd($sessionId, $telco->registerUser($address, $_SESSION["category"]), $address);
                    break;
                default:
                    $_SESSION["menu"] = "main";
                    $sender->ussd($sessionId, $responseMsg["main"], $address);
                    break;
            }
            break;
    }
    
}
?>